#ifndef FACE_VERTEX_MESH_INCLUDED

#include "i_pathengine.h"
#include <vector>

class cCoordinateMapping;

class cFaceVertexMesh : public iFaceVertexMesh
{
    std::vector<int32_t> _vertexCoords;
    std::vector<int32_t> _vertexIndices;

public:

    //void addTri(const std::vector<int32_t>& triVertexCoords);
    void addTri(const int32_t* triVertexCoords);

    void applyCoordinateMapping(const cCoordinateMapping& mapping);

// iFaceVertexMesh interface

    int32_t faces() const;
    int32_t vertices() const;
    int32_t vertexIndex(int32_t face, int32_t vertexInFace) const;
    int32_t vertexX(int32_t vertex) const;
    int32_t vertexY(int32_t vertex) const;
    float vertexZ(int32_t vertex) const;
    int32_t faceAttribute(int32_t face, int32_t attributeIndex) const;
};

#endif
